
//import 'core-js/modules/es6.symbol'
import React, { Component } from 'react';
import MainLayout from "./core/Layouts/MainLayout";
import {Redirect, Route, Switch} from "react-router-dom";
import {applyMiddleware, compose, createStore} from "redux"
import {Provider} from "react-redux";
import {persistCombineReducers, persistStore} from "redux-persist";
import storage from 'redux-persist/es/storage'
import {PersistGate} from "redux-persist/es/integration/react";
import {ApolloProvider} from "react-apollo";
import {NotificationContainer} from "react-notifications";

import * as reducers from './redux/modules';
import {createClient} from "./api/client";
import redirect from "./redux/middlewares/redirect";
import Loading from "./core/Loading";
import Species from "./scenes/Species";
import Habitats from "./scenes/Habitats";
import Interventi from "./scenes/Interventi";
import Documents from './scenes/Documents';
import Users from "./scenes/Users"
import './App.css';

if (!Number.isNaN){
	Number.isNaN = function isNaN(x){
		return x !== x;
	};
}

if (!String.prototype.endsWith) {
	String.prototype.endsWith = function(search, this_len) {
		if (this_len === undefined || this_len > this.length) {
			this_len = this.length;
		}
		return this.substring(this_len - search.length, this_len) === search;
	};
}

const reducer = persistCombineReducers({storage, key: "root"}, reducers);
const store = createStore(
  reducer,
  window.__REDUX_DEVTOOLS_EXTENSION__ && window.__REDUX_DEVTOOLS_EXTENSION__(),
  compose(
    applyMiddleware(redirect),
  )
);

const client = createClient(store);



class App extends Component {

  constructor(props) {
    super(props);
    this.persistor = persistStore(store, null, () => {

    });
  }

  render() {
    return (
      <PersistGate loading={<Loading />} persistor={this.persistor}>
        <Provider store={store}>
          <ApolloProvider client={client}>
            <MainLayout theme={"blue"}>
              <Switch>
                <Route path={"/species"} component={Species} />
                <Route path={"/habitats"} component={Habitats} />
                <Route path={"/interventi"} component={Interventi} />
	              <Route path={"/documents"} component={Documents} />
                <Route path={"/users"} component={Users} />
                <Redirect to={"/species"} />
              </Switch>
              <NotificationContainer/>
            </MainLayout>
          </ApolloProvider>
        </Provider>
      </PersistGate>
    );
  }
}

export default App;
